// Version/Precision tags are added programmatically on shader load

uniform vec3 uLightAmb;
uniform vec3 uLightDif;
uniform vec3 uLightSky;

uniform sampler2D uTexture;
uniform sampler2D uTextureMask;

uniform vec3 uAddColor;  // Add color
uniform vec3 uFlagColor; // Flag color
uniform vec4 uMulColor;  // Multiplication color

varying vec3 C; // Color
varying vec3 L; // Light
varying vec3 N; // Normal
varying vec2 UV; // UV

void main()
{
  vec3 nN = normalize(N);

  float dotDirection = max(dot(nN, L), 0.0);
  vec3 sunColor = dotDirection * uLightDif;

  float skyDirection = max(0.0, dot(nN, vec3(0, 0, 1)));
  vec3 skyColor = skyDirection * uLightSky;

  vec3 envColor = sunColor + uLightAmb + skyColor;

  vec4 tex = texture2D(uTexture, UV);
  vec4 texMask = texture2D(uTextureMask, UV);

  vec3 diffuseColor = C.rgb * mix(tex.rgb, (tex.r+tex.g+tex.b) / 3 * uFlagColor, texMask.r) * uMulColor.rgb + uAddColor;

  vec3 litColor = diffuseColor * envColor;

  gl_FragColor = vec4(litColor, tex.a * uMulColor.a);
}